local assets =
{
	Asset("ANIM", "anim/vendingmachine.zip"),
    Asset("ATLAS", "images/inventoryimages/vendingmachine.xml"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("vendingmachine")
    inst.AnimState:SetBuild("vendingmachine")
    inst.AnimState:PlayAnimation("idle")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddTag("molebait")
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "vendingmachine"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/vendingmachine.xml"
    inst:AddComponent("selfstacker")
	local function OnDeploy (inst, pt)
    SpawnPrefab("vendingmachine").Transform:SetPosition(pt.x, pt.y, pt.z)
    inst.components.stackable:Get():Remove()
end
    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = OnDeploy
    MakeHauntableLaunchAndSmash(inst)

    return inst
end

return Prefab("sell", fn, assets),
MakePlacer("sell_placer", "vendingmachine", "vendingmachine", "idle")